<?php
/**
 * @var $model N2SystemAnimationModel
 */

$sets = $model->getSets();

$backgroundAnimations = new stdClass();
N2JS::addFirstCode("
    new NextendBackgroundAnimationManager({
        setsIdentifier: '" . $model->type . "set',
        sets: " . json_encode($sets) . ",
        visuals: " . json_encode($backgroundAnimations) . ",
        ajaxUrl: '" . $this->appType->router->createAjaxUrl(array('backgroundanimation/index')) . "'
    });
");
?>
<div class="n2-form-tab ">
    <div class="n2-heading-controls n2-content-box-title-bg">
        <div class="n2-table n2-table-fixed">
            <div class="n2-tr">
                <div class="n2-td n2-h2">
                    <?php n2_e('Preview'); ?>
                </div>

                <div class="n2-td n2-last n2-visual-editor-tabs">
                    <div class="n2-form-element-radio-tab">
                        <div class="n2-radio-option n2-h4 n2-first n2-active">
                            <?php n2_e('Forward'); ?>
                        </div><!-- --><div class="n2-radio-option n2-h4 n2-last">
                            <?php n2_e('Backward'); ?>
                        </div>
                        <input type="hidden" autocomplete="off" value="0" name="n2-background-animation-preview-tabs"
                               id="n2-background-animation-preview-tabs">
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div>
        <div class="n2-bg-animation-slider">

            <div class="n2-bg-animation">
            </div>

            <div class="n2-bg-animation-slide">
                <div class="n2-bg-animation-slide-bg">
                    <img
                        src="<?php echo N2ImageHelperAbstract::SVGToBase64('$system$/images/placeholder/image.svg'); ?>"/>
                </div>
            </div>

            <div class="n2-bg-animation-slide" style="opacity: 0;">
                <div class="n2-bg-animation-slide-bg">
                    <img
                        src="<?php echo N2ImageHelperAbstract::SVGToBase64('$system$/images/placeholder/imageback.svg'); ?>"/>
                </div>
            </div>
        </div>

        <style>
            #n2-lightbox-backgroundanimation .n2-content-area {
                overflow: hidden;
            }

            .n2-bg-animation-slider {
                position: relative;
                width: 770px;
                height: 532px;
                margin: 20px;
                /*overflow: hidden;*/
                z-index: 3;
            }

            .n2-bg-animation,
            .n2-bg-animation-slide {
                position: absolute;
                left: 0;
                top: 0;
                width: 770px;
                height: 532px;
            }

            .n2-bg-animation-slide {
                z-index: 2;
            }

            .n2-bg-animation-slider img {
                display: block;
                width: 100%;
            }

            .n2-3d-side {
                position: absolute;
                left: 0;
                top: 0;
                overflow: hidden;
                background: #333;
                outline: 1px solid rgba(0, 0, 0, 0);
            }

        </style>
    </div>
</div>