<?php
/**
 * @var $model N2SystemStyleModel
 */

$sets = $model->getSets();

N2StyleRenderer::$sets[] = $sets[0]['id'];

$styles = array();
foreach (array_unique(N2StyleRenderer::$sets) AS $setId) {
    $styles[$setId] = $model->getVisuals($setId);
}

N2JS::addFirstCode("
    new NextendStyleManager({
        setsIdentifier: '" . $model->type . "set',
        sets: " . json_encode($sets) . ",
        visuals: " . json_encode($styles) . ",
        renderer: {
            pre: '" . N2StyleRenderer::$pre . "',
            usedStyles: " . json_encode(N2StyleRenderer::$styles) . ",
            modes: " . json_encode(N2StyleRenderer::$mode) . "
        },
        ajaxUrl: '" . $this->appType->router->createAjaxUrl(array('style/index')) . "'
    });
");
?>
    <div class="n2-form-tab ">
        <div class="n2-heading-controls n2-content-box-title-bg">
            <div class="n2-table n2-table-fixed">
                <div class="n2-tr">
                    <div class="n2-td n2-h2">
                        <?php n2_e('Style settings'); ?>
                    </div>

                    <div class="n2-td n2-last n2-visual-editor-tabs">
                        <a href="#" class="n2-button n2-button-v n2-button-medium n2-button-grey n2-editor-clear-tab n2-h5 n2-uc"
                           style="display: none;"><?php n2_e('Clear tab'); ?></a>

                        <div class="n2-form-element-radio-tab">
                            <div class="n2-radio-option n2-h4 n2-first n2-last n2-active">
                                #0
                            </div>
                            <input type="hidden" autocomplete="off" value="0" name="n2-style-editor-tabs"
                                   id="n2-style-editor-tabs">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div>
            <?php
            $model->renderForm();
            ?>
        </div>
    </div>

    <div class="n2-form-tab n2-editor-preview-box">
        <div class="n2-heading-controls n2-content-box-title-bg">
            <div class="n2-table n2-table-fixed">
                <div class="n2-tr">
                    <div class="n2-td n2-h2">
                        <?php n2_e('Preview'); ?>
                    </div>

                    <div class="n2-td n2-last n2-visual-editor-preview-tab">
                        <div class="n2-form-element-radio-tab n2-expert">
                            <div class="n2-radio-option n2-h4 n2-first n2-last n2-active">
                                <?php n2_e('Default'); ?>
                            </div>
                            <input type="hidden" autocomplete="off" value="0" name="n2-style-editor-preview-mode"
                                   id="n2-style-editor-preview-mode">
                        </div>
                        <div class="n2-editor-background-color">
                            <div style="" class="n2-form-element-text n2-form-element-color n2-border-radius">
                                <div class="n2-sp-replacer">
                                    <div class="n2-sp-preview">
                                        <div class="n2-sp-preview-inner"></div>
                                    </div>
                                    <div class="n2-sp-dd">▲</div>
                                </div>
                                <input type="text" autocomplete="off" class="n2-h5" value="ced3d5"
                                       name="n2-style-editor-background-color" id="n2-style-editor-background-color">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="n2-style-editor-preview">
        </div>
    </div>

<?php
$model->renderFormExtra();
?>