<?php
/**
* Show/Hide Site Title when logo is displayed
* @author Frenchtastic
* @since Coeur 1.7
*/
$wp_customize->add_setting( 'hide_site_title', array(
    'default'           => false,
    'sanitize_callback' => 'coeur_sanitize_checkbox',
));

$wp_customize->add_control( 'coeur_hide_site_title', array(
    'description' => 'This option will only work if you have uploaded a logo.',
    'type' => 'checkbox',
    'label' => 'Replace title with logo',
    'section' => 'title_tagline',
    'settings' => 'hide_site_title'
));
// -----------------------------------------------------------------------------

/**
* Footer copyright text
* @author Frenchtastic
* @since Coeur 1.0
*/
$wp_customize->add_setting('footer_copy', array(
    'default'        => '<a href="'.esc_url('http://frenchtastic.eu').'">Design by Frenchtastic.eu</a>',
    'capability'     => 'edit_theme_options',
    'type'           => 'theme_mod',
    'transport'      => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
    ));

$wp_customize->add_control('coeur_footer_copy', array(
    'label'      => __('Footer Copyright', 'coeur'),
    'section'    => 'title_tagline',
    'settings'   => 'footer_copy'
));
// -----------------------------------------------------------------------------